# confidence_intervals.R
# Confidence intervals for elytra data

# Load necessary libraries
library(ggplot2)
library(psych)

# Function to calculate intervals for sigma^2
cisig2 <- function(y,alpha){
s2 <- var(y)
n <- length(y)
lower <- (n-1)*s2/qchisq(1-alpha/2,n-1)
upper <- (n-1)*s2/qchisq(alpha/2,n-1)
return(c(lower,upper))
}

# Read in data set
elytra <- read.table(header=T,colClasses=c("numeric"),text="
length
5.0
5.1
5.2
5.9
4.8
5.5
4.8
5.1
5.0
5.1
")

# Print the data
elytra

# Graphics using ggplot2
ggplot(elytra,aes(length))+
geom_histogram(binwidth=0.5)

# Descriptive statistics
attach(elytra)
describe(length)

# Confidence intervals for mu
t.test(length)
t.test(length,conf.level=0.99)

# Confidence intervals for sigma^2 and sigma
alpha <- 0.05 # 95% c.i.
cisig2out <- cisig2(length,alpha)
# 95% c.i. for sigma^2
cisig2out
# 95% c.i. for sigma
sqrt(cisig2out)
alpha <- 0.01 # 99% c.i.
cisig2out <- cisig2(length,alpha)
# 99% c.i. for sigma^2
cisig2out
# 99% c.i. for sigma
sqrt(cisig2out)
detach(elytra)